<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no">
		<script language=JavaScript src="ajax.js" type=text/javascript></script>
		<title>Virtual Assistant</title>
		<meta name="description" content="Virtual Assistant">
		<script type="text/javascript" src="./libgif.js"></script>
		
		<!-- jQuery dan ResponsiveVoice -->
		<script type="text/javascript" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script src="https://code.responsivevoice.org/responsivevoice.js?key=X9eqNh2A"></script>
		
		<style>			
			/* the superGifCanvas elements can be styled if you need to*/
			/*
			.superGifCanvas {
				width:100%;
			}
			*/
			* {
				-webkit-tap-highlight-color: rgba(0, 0, 0, 0);
			}
			.guierrormessage {
				color: #FF0000;
			}
			.guioption{
				width: 280px;
				padding: 0.2em;
				font-size: 1em;
				display: inline-block;
				box-shadow: 0 2px 3px rgba(0, 0, 0, 0.1) inset;
			}
			#giferrormessage {
				display: inline-block;
			}
			#newgifbutton {
				font-size: 1.0rem;
				padding: 0.5rem 0.6em;
				background: #69c773;
				border-bottom: 1px solid #498b50;
				color: white;
				-webkit-font-smoothing: antialiased;
				font-weight: bold;
				margin: 0;
				height: 35px;
				text-align: center;
			}
			#texttospeakinput {
				width:96%;
			}
			.superGifCanvas{
				max-width: 100%; 
			}
			#answer {
				margin: 15px;
				padding: 10px;
				border: 1px solid #ddd;
				border-radius: 5px;
				background-color: #f9f9f9;
				min-height: 20px;
			}
		</style>
		
		<script type="text/javascript">
			// Variabel global untuk jawaban
			var currentAnswer = 'Halo. Ada yang bisa saya bantu?';
			
			// Fungsi untuk memproses pertanyaan ke chatbot
			function processQuestion(question) {
				$.ajax({
					url: "https://david.si2024.com/Program-O/chatbot/conversation_start.php?bot_id=1&say=halo",
					data: {
						bot_id: 1,
						convo_id: "",
						say: question
					},
					dataType: "json",
					success: function(data) {
						if (data && data.botsay) {
							currentAnswer = data.botsay;
							$("#answer").text(currentAnswer);
							
							// Mengucapkan jawaban dengan ResponsiveVoice
							responsiveVoice.speak(currentAnswer, "Indonesian Female", {
								rate: 1,
								pitch: 1,
								volume: 1,
								onstart: function() {
									console.log("Mulai berbicara: " + currentAnswer);
								},
								onend: function() {
									console.log("Selesai berbicara");
								}
							});
						}
					},
					error: function() {
						currentAnswer = "Maaf, terjadi kesalahan saat menghubungi chatbot.";
						$("#answer").text(currentAnswer);
						responsiveVoice.speak(currentAnswer, "Indonesian Female");
					}
				});
			}
			
			// Fungsi untuk animasi (mengirim pertanyaan)
			function animasi(form) {
				var question = form.say.value;
				if (question.trim() !== "") {
					$("#waitingdiv").show();
					processQuestion(question);
					form.say.value = "";
				}
			}

			// Speech Recognition
			var recognition = new (window.SpeechRecognition || window.webkitSpeechRecognition)();
			recognition.continuous = false;
			recognition.lang = 'id-ID';
			recognition.interimResults = false;
			recognition.maxAlternatives = 1;

			function startVoiceInput(form){
				recognition.onstart = function(event) {
					form.say.value = "";
					document.getElementById("loadingstat").innerHTML="<span style=\"font-family: Tahoma; font-size:12; background-color: #FF0000; color: #FFFFFF; align: right\"><blink>&nbsp;Mendengarkan suara Anda...&nbsp;</blink></span>";
				}
				
				recognition.onresult = function(event) { 
					console.log(event);
					var transcript = "";
					for(var i = 0; i < event.results.length; i++){
						transcript += event.results[i][0].transcript;
					}
					form.say.value = transcript;
					
					// Otomatis kirim setelah selesai berbicara
					if(transcript.trim() !== "") {
						animasi(form);
					}
				}		
				
				recognition.onend = function() {
					document.getElementById("loadingstat").innerHTML="";
				};
				
				recognition.onerror = function(event) {
					console.error('Speech recognition error', event.error);
					document.getElementById("loadingstat").innerHTML="";
				};
				
				recognition.start();
			}
			
			// Inisialisasi saat halaman dimuat
			$(document).ready(function() {
				$("#waitingdiv").hide();
				
				// Event listener untuk tombol enter
				$("input[name='say']").keypress(function(e) {
					if(e.which == 13) {
						animasi(this.form);
						return false;
					}
				});
			});
		</script>
	</head>
	
	<body>
		<center>
			<h2>Virtual Assistant</h2>
			
			<label>Tuliskan pertanyaan Anda:</label>
			
			<form name="ask" onsubmit="return false">
				<input type='text' name='say' autofocus /><br>
				<input type='button' value='Kirim' name='submit' class='button' onclick='animasi(this.form)'/> 
				<input id="bStart" type="button" value="Gunakan Suara" onclick="startVoiceInput(this.form);" />
			</form>
			
			<div id="answer">
				<?php echo isset($answer) ? $answer : 'Halo. Ada yang bisa saya bantu?'; ?>
			</div>
			
			<div id="ttsoptions">
				<div style="visibility:hidden;">
					<label>Voice:</label>
					<select id="voiceSelecter" class="guioption"></select>
				</div>
				<div>
					<input type="hidden" id="texttospeakinput" class="guioption" onClick="this.setSelectionRange(0, this.value.length)" >
					<div id="texterrormessage" class="guierrormessage"></div>
				</div>
				<div>
					<input type="hidden" id="gifurlinput" value="mygif.gif" class="guioption" onClick="this.setSelectionRange(0, this.value.length)">
					<div id="giferrormessage" class="guierrormessage"></div>
				</div>
			</div>
			
			<div id="instruction"></div>
			
			<div>
				<div id="imagecontainer">
					<img id="exampleimg" src="mygif.gif" rel:animated_src="mygif.gif" rel:auto_play="0" width="300" height="300" />
				</div>
			</div>
			
			<script type="text/javascript" src="./example.js"></script>
			
			<div id="waitingdiv" style="display: none;">
				Memproses Jawaban.....<br>
			</div>
			
			<div id="loadingstat" style="position: absolute; top: 5px; left: 5px; width: 200px; height: 16px; z-index: 3"></div>
		</center>
	</body>
</html>