<?php
session_start();
require 'db.php';

// Cek login
if (!isset($_SESSION['user_id'])) { header("Location: index.php"); exit; }

$user_id = $_SESSION['user_id']; // Penting untuk QR Code unik

// Ambil semua event urut tanggal
$events = mysqli_query($conn, "SELECT * FROM events ORDER BY date ASC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>All Events - Titik Kumpul</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>

    <div class="mobile-container">
        
        <div class="header-home" style="border-bottom: 1px solid #eee; padding-bottom: 15px; margin-bottom: 20px;">
            <a href="home.php" style="text-decoration:none; color: #333; font-size:18px;">
                <i class="fa-solid fa-arrow-left"></i>
            </a>
            <h3 style="font-size: 18px; font-weight: 700; margin: 0;">Semua Event</h3>
            <div style="width: 20px;"></div> 
        </div>

        <div style="padding: 0 20px 100px 20px;">
            
            <?php while($row = mysqli_fetch_assoc($events)): 
                 // Format Tanggal & Jam
                 $dateObj = new DateTime($row['date']);
                 $dateStr = $dateObj->format('d M Y');
                 $timeStr = $dateObj->format('H:i'); // Ambil jam untuk modal
                 
                 // Badge Color
                 $badgeClass = ($row['type'] == 'Required') ? 'badge-purple' : 'badge-orange';
                 
                 // QR Data (User ID + Event ID)
                 $qrData = $user_id . '-' . $row['id'];
            ?>
            
            <div class="card-item">
                
                <div class="card-top-row">
                    <div style="flex: 1;">
                        <h4 class="card-title"><?php echo $row['title']; ?></h4>
                        <span class="custom-badge <?php echo $badgeClass; ?>">
                            <?php echo $row['type']; ?>
                        </span>
                    </div>
                    
                    <button onclick="openModal('<?php echo addslashes($row['title']); ?>', '<?php echo $dateStr; ?>', '<?php echo $timeStr; ?>', '<?php echo $qrData; ?>')" class="qr-icon-btn">
                        <i class="fa-solid fa-qrcode"></i>
                    </button>
                </div>

                <p class="card-desc">
                    <?php echo $row['description']; ?>
                </p>

                <div class="card-footer">
                    <div class="footer-item">
                        <i class="fa-regular fa-calendar"></i> 
                        <?php echo $dateStr; ?>
                    </div>
                    <div class="footer-item">
                        <i class="fa-solid fa-location-dot"></i> 
                        <?php echo $row['location']; ?>
                    </div>
                </div>

            </div>
            <?php endwhile; ?>
        </div>

        <div class="bottom-nav">
            <a href="home.php" class="nav-item">
                <i class="fa-solid fa-house"></i>
                Home
            </a>
            <a href="view_full_event.php" class="nav-item active">
                <i class="fa-solid fa-book-open"></i>
                Event
            </a>
            <a href="barcode.php" class="nav-item">
                <i class="fa-solid fa-qrcode"></i>
                Barcode
            </a>
        </div>

    </div>

    <div id="modalOverlay" class="modal-overlay" onclick="closeModal(event)">
        <div class="modal-card">
            <div class="modal-header">
                SCAN QR CODE
                <i class="fa-solid fa-xmark close-icon" onclick="forceClose()"></i>
            </div>
            <div class="modal-body">
                <div style="background: #f8f9fa; padding: 10px; border-radius: 8px; margin-bottom: 15px; text-align: left;">
                    <h3 id="mTitle" style="font-size: 16px; margin: 0 0 5px 0;">Event</h3>
                    <p style="font-size: 12px; color: #666; margin:0;"><span id="mDate">Date</span> • <span id="mTime">Time</span></p>
                </div>
                
                <div style="border: 1px dashed #ccc; padding: 10px; display: inline-block; border-radius: 10px;">
                    <img id="mQR" src="" alt="QR" style="width: 180px; height: 180px; display: block;">
                </div>
                
                <p style="font-size: 11px; color: #888; margin-top: 15px;">
                    Tunjukkan ke panitia saat masuk.
                </p>
            </div>
        </div>
    </div>

    <script>
        const overlay = document.getElementById('modalOverlay');
        const mTitle = document.getElementById('mTitle');
        const mDate = document.getElementById('mDate');
        const mTime = document.getElementById('mTime');
        const mQR = document.getElementById('mQR');

        function openModal(title, date, time, qrData) {
            mTitle.innerText = title;
            mDate.innerText = date;
            mTime.innerText = time;
            // Generate QR Code via API
            mQR.src = `https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=${qrData}`;
            
            overlay.style.display = 'flex';
        }

        function forceClose() { overlay.style.display = 'none'; }
        
        function closeModal(e) { 
            if (e.target === overlay) {
                overlay.style.display = 'none';
            }
        }
    </script>
</body>
</html>